<?php

namespace App\Libraries;

use App;

class Parser
{

    public $reader;
    public $optimized_feeds;

    public static function xml($url)
    {
        $reader = new \Sabre\Xml\Reader();

        $reader->xml(self::url_get_contents($url));

        $feeds = $reader->parse();

        $loopers = $feeds['value'][0]['value'];

        $optimized_feeds = [];

        foreach ($loopers as $loop) {

            if ($loop['name'] == "{}title") {
                $optimized_feeds['channel']['title'] = $loop['value'];
            }

            if ($loop['name'] == "{}link") {
                $optimized_feeds['channel']['link'] = $loop['value'];
            }

            if ($loop['name'] == "{}description") {
                $optimized_feeds['channel']['description'] = $loop['value'];
            }

            if ($loop['name'] == "{http://purl.org/rss/1.0/modules/syndication/}updatePeriod") {
                $optimized_feeds['channel']['updatePeriod'] = $loop['value'];
            }

            if ($loop['name'] == "{http://purl.org/rss/1.0/modules/syndication/}updateFrequency") {
                $optimized_feeds['channel']['updateFrequency'] = $loop['value'];
            }

            if ($loop['name'] == "{}language") {
                $optimized_feeds['channel']['language'] = $loop['value'];
            }

            if ($loop['name'] == "{}pubDate") {
                $optimized_feeds['channel']['pubDate'] = $loop['value'];
            }

            if ($loop['name'] == "{}lastBuildDate") {
                $optimized_feeds['channel']['lastBuildDate'] = $loop['value'];
            }

            if ($loop['name'] == "{}generator") {
                $optimized_feeds['channel']['generator'] = $loop['value'];
            }

            if ($loop['name'] == "{}item") {

                $values = $loop['value'];

                $title = "";
                $link = "";
                $description = "";
                $pubDate = "";

                foreach ($values as $value) {
                    if ($value['name'] == '{}title') {
                        $title = $value['value'];
                    }

                    if ($value['name'] == '{}link') {
                        $link = $value['value'];
                    }

                    if ($value['name'] == '{}pubDate') {
                        $pubDate = $value['value'];
                    }

                    if ($value['name'] == '{}description') {
                        $description = $value['value'];
                    }

                    if ($value['name'] == '{http://purl.org/rss/1.0/modules/content/}encoded') {
                        $description = $value['value'];
                    }

                }

                $optimized_feeds['channel']['item'][] = ['title' => $title, 'link' => $link, 'description' => $description, 'pubDate' => $pubDate];
            }
        }

        return $optimized_feeds;
    }

    public static function url_get_contents($Url)
    {
        if (!function_exists('curl_init')) {
            die('CURL is not installed!');
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $Url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }

}